/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.signals.actions.account.delete.DeleteAccountAction;
import com.floragunn.signals.actions.account.delete.DeleteAccountRequest;
import com.floragunn.signals.actions.account.delete.DeleteAccountResponse;
import com.floragunn.signals.actions.account.get.GetAccountAction;
import com.floragunn.signals.actions.account.get.GetAccountRequest;
import com.floragunn.signals.actions.account.get.GetAccountResponse;
import com.floragunn.signals.actions.account.put.PutAccountAction;
import com.floragunn.signals.actions.account.put.PutAccountRequest;
import com.floragunn.signals.actions.account.put.PutAccountResponse;
import com.floragunn.signals.api.SignalsBaseRestHandler;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class AccountApiAction
extends SignalsBaseRestHandler {
    public AccountApiAction(Settings settings, RestController controller) {
        super(settings);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_signals/account/{type}/{id}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/_signals/account/{type}/{id}"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_signals/account/{type}/{id}"));
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String accountType = request.param("type");
        if (accountType == null) {
            return channel -> this.errorResponse((RestChannel)channel, RestStatus.BAD_REQUEST, "No type specified");
        }
        String id = request.param("id");
        if (Strings.isNullOrEmpty((String)id)) {
            return channel -> this.errorResponse((RestChannel)channel, RestStatus.BAD_REQUEST, "No id specified");
        }
        switch (request.method()) {
            case GET: {
                return this.handleGet(accountType, id, request, (Client)client);
            }
            case PUT: {
                return this.handlePut(accountType, id, request, (Client)client);
            }
            case DELETE: {
                return this.handleDelete(accountType, id, request, (Client)client);
            }
        }
        throw new IllegalArgumentException(request.method() + " not supported");
    }

    protected BaseRestHandler.RestChannelConsumer handleGet(String accountType, String id, RestRequest request, Client client) throws IOException {
        return channel -> client.execute((ActionType)GetAccountAction.INSTANCE, (ActionRequest)new GetAccountRequest(accountType, id), (ActionListener)new ActionListener<GetAccountResponse>(){

            public void onResponse(GetAccountResponse response) {
                if (response.isExists()) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, AccountApiAction.convertToJson(channel, (ToXContent)response, ToXContent.EMPTY_PARAMS)));
                } else {
                    AccountApiAction.this.errorResponse(channel, RestStatus.NOT_FOUND, "Not found");
                }
            }

            public void onFailure(Exception e) {
                AccountApiAction.this.errorResponse(channel, e);
            }
        });
    }

    protected BaseRestHandler.RestChannelConsumer handleDelete(String accountType, String id, RestRequest request, Client client) throws IOException {
        return channel -> client.execute((ActionType)DeleteAccountAction.INSTANCE, (ActionRequest)new DeleteAccountRequest(accountType, id), (ActionListener)new ActionListener<DeleteAccountResponse>(){

            public void onResponse(DeleteAccountResponse response) {
                if (response.getResult() == DeleteAccountResponse.Result.DELETED) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, AccountApiAction.convertToJson(channel, (ToXContent)response, ToXContent.EMPTY_PARAMS)));
                } else {
                    AccountApiAction.this.errorResponse(channel, response.getRestStatus(), response.getMessage());
                }
            }

            public void onFailure(Exception e) {
                AccountApiAction.this.errorResponse(channel, e);
            }
        });
    }

    protected BaseRestHandler.RestChannelConsumer handlePut(String accountType, String id, RestRequest request, Client client) throws IOException {
        if (request.getXContentType() != XContentType.JSON) {
            return channel -> this.errorResponse((RestChannel)channel, RestStatus.UNPROCESSABLE_ENTITY, "Accounts must be of content type application/json");
        }
        BytesReference content = request.content();
        return channel -> client.execute((ActionType)PutAccountAction.INSTANCE, (ActionRequest)new PutAccountRequest(accountType, id, content, XContentType.JSON), (ActionListener)new ActionListener<PutAccountResponse>(){

            public void onResponse(PutAccountResponse response) {
                if (response.getResult() == DocWriteResponse.Result.CREATED || response.getResult() == DocWriteResponse.Result.UPDATED) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(response.getRestStatus(), AccountApiAction.convertToJson(channel, (ToXContent)response, ToXContent.EMPTY_PARAMS)));
                } else {
                    AccountApiAction.this.errorResponse(channel, response.getRestStatus(), response.getMessage(), response.getDetailJsonDocument());
                }
            }

            public void onFailure(Exception e) {
                AccountApiAction.this.errorResponse(channel, e);
            }
        });
    }

    protected static XContentBuilder convertToJson(RestChannel channel, ToXContent toXContent, ToXContent.Params params) {
        try {
            XContentBuilder builder = channel.newBuilder();
            toXContent.toXContent(builder, params);
            return builder;
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    public String getName() {
        return "Account Action";
    }
}

